from os.path import dirname, abspath, join, basename, normpath


class FluidLabPaths:
    ROOT = normpath(join(dirname(abspath(__file__)), ".."))
    ROOT_BASENAME = basename(ROOT)
    LIBS = join(ROOT, "libs")
    LIBS_ICONS = join(LIBS, "icons")
    LIBS_BLEND_PATH = join(LIBS, "blendfiles")
    LIBS_MATERIALS_PATH = join(LIBS, "materials")
    LIBS_MAT_THUMBS_PATH = join(LIBS_MATERIALS_PATH, "thumbnails")




class FluidLabPreferences:
    def get_prefs(context):
        return context.preferences.addons[FluidLabPaths.ROOT_BASENAME].preferences
